import numpy as np
import sys
import os

if len(sys.argv) == 2:
	filename=sys.argv[1]
	suffix = ""
elif len(sys.argv) == 3:
	filename=sys.argv[1]
	suffix = sys.argv[2]
else:
	assert False, "Incorrect number of arguments"
result_prefix="Enter path here"

data = np.genfromtxt(filename,delimiter=',',dtype=str)
print(data)

for i in range(1,len(data),3):
	for j in range(1,10):
		year_name = data[i][0].split('-')[0]
		file_name = data[0][j] + '-' + year_name + suffix + '.dat'
		f = open(os.path.join(result_prefix,file_name), 'w')
		f.write('time\tscore\tsolver\n')
		for k in range(0, 3):
			f.write(data[i+k][0].split('-')[1] + '\t' + str(data[i+k][j]) + '\t' + data[0][j] + '\n')
		f.close()
		
for i in range(1,len(data)):
	for j in range(10,len(data[i]),7):
		algorithm_name = data[0][j].split('-')[0]
		file_name = algorithm_name + '-' + data[i][0] + suffix + '.dat'
		f = open(os.path.join(result_prefix,file_name),'w')
		f.write('clusters\tscore\n')
		for k in range(0,7):
			if j+k >= len(data[i]):
				break
			cluster_count = data[0][j+k].split('-')[1]
			f.write(cluster_count + '\t' + str(data[i][j+k]) + '\n')
		if j==10:
			f.write('\#weights\t' + str(data[i][8]) + '\n')
		f.close()

	
